
browser.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if(readermodeURL != window.location.href) { return; }
    debugmode && console.log('(readermode)', request.cmd);
    switch(request.cmd) {
        case 'populateReader':
            populateReader(request.domNodes, request.attribution, request.originalURL, sendResponse);
            return true;
    }
});

function populateReader(domNodes, attribution, originalURL, sendResponse) {

    function appendNodes(domNodes, attribution, originalURL, sendResponse) {
        readermodeTemplateHTML.then(html => {
            if(!document.querySelector('#Container')) {
                document.body.innerHTML = html;
            }
            readermode.domNodes = domNodes;
            readermode.attribution = attribution;
            readermode.originalURL = originalURL;
            let content = document.querySelector('#Content');
            tryAppendAll(domNodes, attribution, content);
            togglePlayer(true);
            sendResponse && sendResponse();
        });
    }

    appendNodes(domNodes, attribution, originalURL, sendResponse);

    populateReader = appendNodes;
}

function tryAppendAll(domNodes, attribution, container) {

    let node;
    //let container = getBody().getElementsByTagName('div')[0];
    let attributionDone = false;
    let foundFirstHeader;
    container.innerHTML = '';

    for(let i=0; i < domNodes.length; i++) {

        node = domNodes[i];

        let overrideNodeName;
        if((!foundFirstHeader) && node.nodeType == 'header') {
            document.querySelector('title').innerHTML = 'WebOutLoud Reader Mode tab | '+(node.text ?? node.innerHTML);
            foundFirstHeader = true;
            overrideNodeName = 'H1';
        }
        let element = appendNode(container, node, overrideNodeName);
        if(!element) { continue; }

        if(node.nodeType == 'header' && !attributionDone) {
            attributionDone = true;

            element.classList.add('first');

            //document.getElementsByTagName('title')[0].innerText = node.text;

            let att = document.createElement('div');
            att.setAttribute('data-wol-readable', 'false');
            att.id = 'ArticleInfo';
            if(attribution.author.text) {
                let author = document.createElement('div');
                author.className = 'authorname';
                author.innerText = 'By '+attribution.author.text;
                att.appendChild(author);
            }
            let domainDiv = document.createElement('div');

            let domainLink = document.createElement('a');
            domainLink.title = 'View original content';
            domainLink.className = 'site';
            domainLink.innerText = attribution.domain;
            domainLink.href = attribution.originalURL;
            domainLink.addEventListener('click', async function(e) {
                e.preventDefault();
                await browserRuntimeSendMessage({ cmd : 'openOrFocus', url : attribution.originalURL });
            });

            // let origLink = document.createElement('a');
            // origLink.innerText = 'Original Article';
            // origLink.href = attribution.originalURL;
            // origLink.addEventListener('click', function(e) {
            //     e.stopImmediatePropagation();
            //     e.preventDefault();
            //     window.webkit.messageHandlers.openInBrowser.postMessage(attribution.originalURL);
            // });
            // domainDiv.appendChild(origLink);

            domainDiv.appendChild(domainLink);

            att.appendChild(domainDiv);

            container.appendChild(att);
        }

    }

    return ''
}

function appendNode(parent, node, overrideNodeName) {

    let isTextNode = node.nodeName == "#text";
    let element = node.nodeName == '#text' ?
        document.createTextNode(node.text) : document.createElement(overrideNodeName || node.nodeName);
    let div;
    if(node.classAttribute) {
        element.setAttribute('class', node.classAttribute);
    }

    if(element.nodeName == 'IMG') {
        element.onerror = function() {
            if(!div) { return }
            div.style.display = 'none';
        };
        element.src = node.src;
        if(!(element.src||'').trim()) { return null }
        //element.style.maxWidth = '600px';

        div = document.createElement('div');
        div.classList.add('image-container');
        div.appendChild(element);

        if(node.caption) {
            let caption = document.createElement('p');
            caption.classList.add('image-caption');
            //caption.style.fontSize = '12px';
            caption.appendChild(document.createTextNode(node.caption));
            div.appendChild(caption);
        }

        parent.appendChild(div);
        return div;

    }

    if((!node.children) || node.children.length == 0) {

        parent.appendChild(element);
        if(isTextNode) { return }
        if(node.innerHTML) {
            element.innerHTML = node.innerHTML;
        } else if(node.text) {
            element.innerText = node.text;
        }

    } else if(node.children && node.children.length) {

        parent.appendChild(element);
        for(let i=0; i < node.children.length; i++) {
            appendNode(element, node.children[i]);
        }
    }

    return element;

}

function getBody() {
    return document.getElementsByTagName('body')[0];
}