
/*
Focus on INPUT field if any character is pressed
*/
document.onkeydown = function (e) {
    if (isAlphabetKeysPressed(e)) {
        // resetHighlight();
        focusInputField();

        // Listen for list text auto complete change to update highlight.
        if (!listenerSearchAutoCompleteAdded) {
            var targetNode = document.getElementById(AMP_LIST_AUTO_COMPLETE_ID);
            if (targetNode) {
                // Observe the target node for configured mutations
                Observer.observe(targetNode, Config);
                listenerSearchAutoCompleteAdded = true;
            }
        }
        return;
    }

    if (isUpDownKeyPressed(e)) {
        if (isSearchAutoCompleteVisible()) {
            navigateAutoCompleteSearch(e);
            e.preventDefault();
            return;
        }
    }

    if (isEnterKeyPressed(e)) {
        if (isSearchAutoCompleteVisible() && isHighLighting()) {
            lookUpSelectHighlight();
            e.preventDefault();
            return;
        }
    }

    if (isEscapeKeyPressed(e)) {
        if (isSearchAutoCompleteVisible() && isHighLighting()) {
            resetHighlight();
            e.preventDefault();
            return;
        }
    }
};

// FOCUS SEARCH BOX
function isAlphabetKeysPressed(e) {
    if (e.ctrlKey || e.altKey || e.metaKey) {
        return false;
    }
    var code = e.keyCode ? e.keyCode : e.which;
    return code >= 65 && code <= 90 || code >= 97 && code <= 122;
}

function focusInputField() {
    var header = document.getElementById('header');
    header.style.top = "0px";
    header.style.position = "fixed";
    header.style.opacity = "1";

    document.getElementById(SEARCH_BOX_ID).focus();
}
// FOCUS SEARCH BOX - END

// SELECT WORD ON AUTOCOMPLETE SEARCH
var highlightText;
var highlightIndex = -1;

var normalColor;

function isHighLighting() {
    return highlightText && highlightIndex >= 0;
}

function resetHighlight() {
    log('reset highlight');

    // Try to reset background
    var list = document.getElementById(AMP_LIST_AUTO_COMPLETE_ID)
            .getElementsByClassName(LIST_AUTO_COMPLETE_ITEM_CLASS);
    if (list) {
        dehighlight(list[highlightIndex]);
    }

    highlightText = null;
    highlightIndex = -1;
}

function isSearchAutoCompleteVisible() {
    if (document.getElementById(AMP_LIST_AUTO_COMPLETE_ID).offsetParent === null) {
        log(`searchAutoComplete - not visible.`);
        return false;
    } else {
        return true;
    }
}

function isUpDownKeyPressed(e) {
    if (e.ctrlKey || e.altKey || e.metaKey) {
        return false;
    }
    var code = e.keyCode ? e.keyCode : e.which;
    return code == 38 || code == 40;
}

function navigateAutoCompleteSearch(e) {
    var code = e.keyCode ? e.keyCode : e.which;
    if (code == 38 || code == 40) {
        var list = document.getElementById(AMP_LIST_AUTO_COMPLETE_ID)
                .getElementsByClassName(LIST_AUTO_COMPLETE_ITEM_CLASS);

        if (list.length <= 0) {
            resetHighlight();
            return;
        }

        if (highlightIndex >= 0) {
            var text = getTextOfItemList(list[highlightIndex]);
            if (text !== highlightText) {
                resetHighlight();
            }
        }

        var newIndex;

        if (code == 38) { // Up
            if (highlightIndex <= 0) {
                newIndex = list.length - 1;
            } else {
                newIndex = highlightIndex - 1;
            }
        } else if (code == 40) { // Down
            if (highlightIndex < 0) {
                newIndex = 0;
            } else if (highlightIndex >= list.length - 1) {
                newIndex = 0;
            } else {
                newIndex = highlightIndex + 1;
            }
        }

        if (list[newIndex]) {
            normalColor = list[newIndex].style.backgroundColor;
            highlight(list[newIndex]);
        } else {
            normalColor = '#FFFFFF'
        }

        if (highlightIndex >= 0 && highlightIndex < list.length) {
            dehighlight(list[highlightIndex]);
        }

        highlightIndex = newIndex;
    } else {
        log(`Code is not Up or Down: ${code}.`);
    }
}

function highlightByText(text) {
    log(`highlightByText: ${text}.`);
    var list = document.getElementById(AMP_LIST_AUTO_COMPLETE_ID)
            .getElementsByClassName(LIST_AUTO_COMPLETE_ITEM_CLASS);

    if (!list || list.length <= 0) {
        return;
    }

    for (let i = 0; i < list.length; i++) {
        var item = list[i];
        if (getTextOfItemList(item) === text) {
            highlightIndex = i;
            highlight(item);
            return;
        }
    }

    resetHighlight();
}

// Trigger dictionay with work being highlight.
function isEnterKeyPressed(e) {
    if (e.ctrlKey || e.altKey || e.metaKey) {
        return false;
    }
    var code = e.keyCode ? e.keyCode : e.which;
    return code == 13;
}

function lookUpSelectHighlight() {
    var list = document.getElementById(AMP_LIST_AUTO_COMPLETE_ID)
            .getElementsByClassName(LIST_AUTO_COMPLETE_ITEM_CLASS);
    if (list) {
        var link = list[highlightIndex].getElementsByTagName('a')[0].href;
        if (link) {
            window.location.href = link;
        }
    }
    resetHighlight();
}

function isEscapeKeyPressed(e) {
    if (e.ctrlKey || e.altKey || e.metaKey) {
        return false;
    }
    var code = e.keyCode ? e.keyCode : e.which;
    return code == 27;
}

function highlight(item) {
    if (item) {
        item.style.background = HIGHLIGHT_COLOR;
        highlightText = getTextOfItemList(item);
    }
}

function dehighlight(item) {
    if (item) {
        item.style.background = normalColor;
    }
}

function getTextOfItemList(item) {
    if (item) {
        var arr = item.getElementsByClassName(AUTO_COMPLETE_CONTENT_CLASS);
        if (arr.length > 0) {
            var span = arr[0];
            if (span) {
                return span.innerText;
            }
        }
    }
    return ""
}
// SELECT WORD ON AUTOCOMPLETE SEARCH - END

// LISTEN SEARCH AUTOCOMPLETE CHANGED
var listenerSearchAutoCompleteAdded = false;

// Options for the observer (which mutations to observe)
const Config = { attributes: false, childList: true, subtree: true };

const DelayListener = 300;
var delayProcessingHighlight = false;

// Callback function to execute when mutations are observed
const callback = function(mutationsList, Observer) {
    for (let mutation of mutationsList) {
        if (mutation.type === 'childList') {
            if (!delayProcessingHighlight) {
                delayProcessingHighlight = true;
                setTimeout(function() {
                    delayProcessingHighlight = false;
                    if (isSearchAutoCompleteVisible()) {
                        if (highlightText) {
                            highlightByText(highlightText);
                        }
                    }
                }, DelayListener);
            }
        } else if (mutation.type === 'attributes') {
            // Ignore
        }
    }
};

// Create an observer instance linked to the callback function
const Observer = new MutationObserver(callback);
// LISTEN SEARCH AUTOCOMPLETE CHANGED - END

/////////////////////////////////////////////
// UTILITIES FUNCTIONS
/////////////////////////////////////////////
function log(sms) {
    if (LOG_ENABLE) {
        console.log(`content_script.js: ${sms}`);
    }
}

/////////////////////////////////////////////
// VARIABLES
/////////////////////////////////////////////
const LOG_ENABLE = false;

const SEARCH_BOX_ID = 'searchword';
const AMP_LIST_AUTO_COMPLETE_ID = 'searchAutoComplete';
const LIST_AUTO_COMPLETE_ITEM_CLASS = 'lmt-5';
const AUTO_COMPLETE_CONTENT_CLASS = 'haxa';

const HIGHLIGHT_COLOR = '#7AADFF';
